﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Text;

namespace PWS.API.Window
{
    public static class WindowAPI
    {
        /// <summary>
        /// پیدا کردن هندل یک پنجره خاص
        /// </summary>
        /// <param name="lpClassName">کلاس پنجره</param>
        /// <param name="lpWindowName">عنوان پنجره</param>
        /// <returns>دستگیره پنجره مورد نظر</returns>
        [DllImport("user32.dll")]
        public static extern IntPtr FindWindow(
            string lpClassName, string lpWindowName);

        /// <summary>
        /// بدست آوردن هندل پنجره فعال
        /// </summary>
        /// <returns>هندل پنجره فعال</returns>
        [DllImport("user32.dll")]
        public static extern IntPtr GetActiveWindow();

        /// <summary>
        /// هندل پنجره ای را که کاربر با آن کار می کند بدست می¬آورد
        /// </summary>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern IntPtr GetForegroundWindow();

        /// <summary>
        /// هندل پنجره دسکتاپ را بدست می آورد
        /// </summary>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern IntPtr GetDesktopWindow();

        /// <summary>
        /// هندل پنجره ای را که در نقطه مورد نظر است بدست می آورد
        /// </summary>
        /// <param name="xPoint">مختصات در محور افقی</param>
        /// <param name="yPoint">مختصات در محور عمودی</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern IntPtr WindowFromPoint(
            int xPoint, int yPoint);

        /// <summary>
        /// هندل پنجره والد یک پنجره خاص را به دست می اورد
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern IntPtr GetParent(IntPtr hWnd);

        /// <summary>
        /// چشمک زن کردن پنجره مورد نظر
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <param name="bInvert">از نوع منطقی بوده و چشمک زن بودن یا نبودن پنجره مورد نظر را مشخص می کند</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool FlashWindow(
            IntPtr hWnd, bool bInvert);

        /// <summary>
        /// بدست اوردن کلاس یک پنجره خاص
        /// </summary>
        /// <param name="hWnd">هندل پنجره</param>
        /// <param name="lpClassName">نام کلاس به عنوان پارامتر خروجی</param>
        /// <param name="nMaxCount">طول بافر مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool GetClassName(
            IntPtr hWnd, 
            StringBuilder 
            lpClassName, 
            int nMaxCount);

        /// <summary>
        /// این تابع عرض و ارتفاع پنجره مورد نظر را بدست می آورد
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <param name="lpRect">اطلاعات بازگشتی</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool GetClientRect(
            IntPtr hWnd, out Rectangle lpRect);

        /// <summary>
        /// این تابع مختصات مکان پنجره مورد نظر را به دست می آورد
        /// </summary>
        /// <param name="hWnd"></param>
        /// <param name="lpRect"></param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool GetWindowRect(
            IntPtr hWnd, out Rectangle lpRect);

        /// <summary>
        /// بدست آوردن عنوان یک پنجره خاص
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <param name="lpString">پارامتر خروجی که عنوان پنجره در آن قرار می گیرد</param>
        /// <param name="nMaxCount">طول بافر مورد نظر </param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool GetWindowText(
            IntPtr hWnd, 
            StringBuilder lpString, int nMaxCount);

        /// <summary>
        /// طول عنوان یک پنجره خاص را بدست می آورد
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern int GetWindowTextLength(IntPtr hWnd);

        /// <summary>
        /// بررسی رابطه پدر و فرزندی دو پنجره
        /// </summary>
        /// <param name="hWndParent">پنجره مادر</param>
        /// <param name="hWnd">پنجره فرزند</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool IsChild(
            IntPtr hWndParent, IntPtr hWnd);

        /// <summary>
        /// بررسی اینکه پنجره مورد نظر در حالت کمینه قرار دارد یا خیر
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool IsIconic(IntPtr hWnd);

        /// <summary>
        /// تعیین می کند این هندل متعلق به یک پنجره (فرم) است یا خیر
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool IsWindow(IntPtr hWnd);

        /// <summary>
        /// تعیین می کند که یک پنجره فعال است یا خیر
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool IsWindowEnabled(IntPtr hWnd);

        /// <summary>
        /// این تابع بررسی می کند که پنجره مورد نظر سیستم یونیکد را پشتیبانی می کند یا خیر
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool IsWindowUnicode(IntPtr hWnd);

        /// <summary>
        /// این تابع وضعیت نمایان بودن یک پنجره خاص را بدست می آورد
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool IsWindowVisible(IntPtr hWnd);

        /// <summary>
        /// این تابع بررسی می کند که پنجره مورد نظر در حالت بیشینه است با خیر
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool IsZoomed(IntPtr hWnd);

        /// <summary>
        /// این تابع جهت تنظیم پنجره فعال به کار می رود
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns>در صورتی که تابع با موفقیت کار خود را انجام دهد هندل پنجره ای را که قبلا فعال بوده برمی گرداند و در صورتی که با شکست مواجه شود صفر را بر می گرداند</returns>
        [DllImport("user32.dll")]
        public static extern IntPtr SetActiveWindow(IntPtr hWnd);

        /// <summary>
        /// این تابع پنجره مورد نظر را بروی سایر پنجره ها قرار می دهد
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns>خروجی این تابع از نوع منطقی بوده و در صورتی که کار خود را با موفقیت انجام دهد مقدار true و در صورت شکست مقدار false را بر می گرداند</returns>
        [DllImport("user32.dll")]
        public static extern bool SetForegroundWindow(IntPtr hWnd);

        /// <summary>
        /// این تابع والد یک کنترل خاص را عوض می کند. در هر پنجره ای ممکن است کنترل های زیادی وجود داشته باشد که والد همه آنها پنجره مورد نظر است ما می توانیم توسط این تابع آنها را به برنامه دیگر متصل نماییم
        /// </summary>
        /// <param name="hWndChild">هندل کنرل فرزندی که می خواهیم والدش را تغییر دهیم</param>
        /// <param name="hWndNewParent">هندل والد جدید</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern IntPtr SetParent(
            IntPtr hWndChild, IntPtr hWndNewParent);

        /// <summary>
        /// این تابع عنوان یک پنجره خاص را تغییر می دهد
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <param name="lpString">عنوان جدید</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool SetWindowText(
            IntPtr hWnd, String lpString);

        /// <summary>
        /// این تابع حالت انیمیشن و افکت های مختلف برای فرم، پنجره و یا اجزای داخل فرم را به وجود می آورد
        /// </summary>
        /// <param name="hwnd">هندل پنجره مورد نظر</param>
        /// <param name="dwTime">مدت زمان انجام انیمیشن به میلی ثانیه</param>
        /// <param name="dwFlags">حالت های انیمیشن</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool AnimateWindow(
            IntPtr hwnd, int dwTime, 
            AnimateWindowFlags dwFlags);

        [Flags]
        public enum AnimateWindowFlags : long
        {
            AW_HOR_POSITIVE = 0x1,
            AW_HOR_NEGATIVE = 0x2,
            AW_VER_POSITIVE = 0x4,
            AW_VER_NEGATIVE = 0x8,
            AW_CENTER = 0x10,
            AW_HIDE = 0x10000,
            AW_ACTIVATE = 0x20000,
            AW_SLIDE = 0x40000,
            AW_BLEND = 0x80000
        }

        /// <summary>
        /// این تابع باعث می شود که پنجره مورد نظر روی تمامی پنجره ها قرار گیرد
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool BringWindowToTop(IntPtr hWnd);

        /// <summary>
        /// این تابع باعث کمینه شدن پنجره مورد نظر می شود
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool CloseWindow(IntPtr hWnd);

        public enum ShowWindowCommands : int
        {
            Hide = 0x0,
            Normal = 0x1,
            ShowMinimized = 0x2,
            Maximize = 0x3,
            ShowMaximized = 0x3,
            ShowNoActivate = 0x4,
            Show = 0x5,
            Minimize = 0x6,
            ShowMinNoActive = 0x7,
            ShowNA = 0x8,
            Restore = 0x9,
            ShowDefault = 0xA,
            ForceMinimize = 0xB
        }

        /// <summary>
        ///این تابع موجب جابجایی و تغییر اندازه پنجره می شود
        /// </summary>
        /// <param name="hWnd">هندل پنجره ای که می خواهیم تغغیر اندازه پیدا کرده یا جابجا شود</param>
        /// <param name="x">این پارامتر مختصات طولی جدید پنجره (سمت چپ پنجره) را مشخص می نماید</param>
        /// <param name="y">این پارامتر مختصات عرضی جدید پنجره (بالای پنجره) را مشخص می نماید</param>
        /// <param name="nWidth">این پارامتر عرض جدید پنجره را مشخص می نماید</param>
        /// <param name="nHeight">این پارامتر ارتفاع جدید پنجره را مشخص می نماید</param>
        /// <param name="bRepaint">این پارامتر مشخص می کند که پنجره مجددا ترسیم شود یا خیر در صورتی که true باشد پنجره از نو ترسیم شده و در صورتی که false وارد کنیم از ترسیم مجدد پنجره خودداری می کند</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool MoveWindow(
            IntPtr hWnd, int x, int y, 
            int nWidth, int nHeight, bool bRepaint);

        /// <summary>
        /// این تابع پنجره ای را که در حالت کمینه است به حالت نرمال تغییر می دهد
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool OpenIcon(IntPtr hWnd);

        /// <summary>
        ///
        /// </summary>
        /// <param name="hWnd">مقدار این پارامتر هندل فرم یا پنجره مورد نظر می باشد</param>
        /// <param name="hWndInsertAfter">مقدار این پارامتر، مکان قرار گرفتن پنجره در مختصات z می باشد (منظور از z این است که پنجره مورد نظر زیر پنجره دیگر قرار بگیرد ویا بالای آن قرار داشته باشد)</param>
        /// <param name="x">مختصات x گوشه سمت چپ و بالای، جدید پنجره مورد نظر میباشد.(پنجره به این مکان انتقال می یابد)</param>
        /// <param name="y">مختصات y گوشه سمت چپ و بالای، جدید پنجره مورد نظر میباشد.(پنجره به این مکان انتقال می یابد)</param>
        /// <param name="cx">مختصات x گوشه سمت راست و پایین، جدید پنجره مورد نظر میباشد.(طول پنجره)</param>
        /// <param name="cy">مختصات y گوشه سمت راست و پایین، جدید پنجره مورد نظر میباشد.(طول پنجره)</param>
        /// <param name="uFlags">نحوه نمایش، حرکت و تغییر طول و عرض در این پارامتر مقداردهی می شود</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool SetWindowPos(IntPtr hWnd, 
            SetWindowPosInsertAfterFlags hWndInsertAfter, 
            int x, int y, int cx, int cy, 
            SetWindowPosFlags uFlags);

        public enum SetWindowPosFlags : uint
        {
            /// <summary>
            /// If the calling thread and the thread that owns the window are attached to different input queues,
            /// the system posts the request to the thread that owns the window. This prevents the calling thread from
            /// blocking its execution while other threads process the request.
            /// </summary>
            /// <remarks>SWP_ASYNCWINDOWPOS</remarks>
            SWP_ASYNCWINDOWPOS = 0x4000,
            /// <summary>
            /// Prevents generation of the WM_SYNCPAINT message.
            /// </summary>
            /// <remarks>SWP_DEFERERASE</remarks>
            SWP_DEFERERASE = 0x2000,
            SWP_DRAWFRAME = 0x20,
            SWP_FRAMECHANGED = 0x20,
            SWP_HIDEWINDOW = 0x80,
            SWP_NOACTIVATE = 0x10,
            SWP_NOCOPYBITS = 0x100,
            SWP_NOMOVE = 0x2,
            /// <summary>
            /// Does not change the owner window's position in the Z order.
            /// </summary>
            /// <remarks>SWP_NOOWNERZORDER</remarks>
            SWP_NOOWNERZORDER = 0x200,
            SWP_NOREDRAW = 0x8,
            /// <summary>
            /// Same as the SWP_NOOWNERZORDER flag.
            /// </summary>
            /// <remarks>SWP_NOREPOSITION</remarks>
            SWP_NOREPOSITION = 0x200,
            ///<summary>
            /// Prevents the window from receiving the WM_WINDOWPOSCHANGING message.
            /// </summary>
            /// <remarks>SWP_NOSENDCHANGING</remarks>
            SWP_NOSENDCHANGING = 0x400,
            SWP_NOSIZE = 0x1,
            SWP_NOZORDER = 0x4,
            SWP_SHOWWINDOW = 0x40,
        }

        public enum SetWindowPosInsertAfterFlags : int
        {
            HWND_TOP = 0,
            HWND_BOTTOM = 1,
            HWND_TOPMOST = -1,
            HWND_NOTOPMOST = -2
        }

        /// <summary>
        /// این تابع برای تنظیم وضعیت نمایش پنجره به کار می¬رود
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <param name="nCmdShow">وضعیت نمایش پنجره</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool ShowWindow(IntPtr hWnd, ShowWindowCommands nCmdShow);

        [DllImport("user32.dll")]
        public static extern int TileWindows(IntPtr hwndParent, int wHow, IntPtr lpRect, int cKids, IntPtr lpKids);

        /// <summary>
        /// این تابع موجب بسته شدن و از حافظه خارج شدن پنجره مورد نظر می شود
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool DestroyWindow(IntPtr hWnd);

        /// <summary>
        ///این تابع یک پنجره خاص را فعال یا غیر فعال می کند
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <param name="bEnable">فعال بودن یا نبودن پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool EnableWindow(IntPtr hWnd, bool bEnable);

        /// <summary>
        /// یافت یک پنجره در ویندوز
        /// </summary>
        /// <param name="parentHwnd">هندل</param>
        /// <param name="childAfterHwnd">هندل فرزند</param>
        /// <param name="className">کلاس پنجره</param>
        /// <param name="windowTitle">عنوان پنجره</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern IntPtr FindWindowEx(IntPtr parentHwnd, 
            IntPtr childAfterHwnd, 
            string className, string windowTitle);

        /// <summary>
        /// چشمک زن کردن پنجره
        /// </summary>
        /// <param name="pwfi"></param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool FlashWindowEx(ref FlashWInfo pwfi);

        [StructLayout(LayoutKind.Sequential)]
        public struct FlashWInfo
        {
            public UInt32 cbSize;
            public IntPtr hwnd;
            public FlashWInfoFlags dwFlags;
            public UInt32 uCount;
            public UInt32 dwTimeout;

            public static UInt32 SizeOf
            {
                get 
                { 
                    return (UInt32)Marshal.SizeOf(
                        typeof(FlashWInfo)); 
                }
            }
        }

        public enum FlashWInfoFlags : uint
        {
            FlashW_Stop = 0x0,
            FlashW_Caption = 0x1,
            FlashW_Tray = 0x2,
            FlashW_All = 0x3,
            FlashW_Timer = 0x4,
            FlashW_TimerOfg = 0x12
        }
    }
}

